%% Rosenbrock Function 
% Not all unimodel functions are simple to optimize. The fitness landscape
% is simple from afar but banana shaped when close to minimum. Rosenbrock's
% variables are strongly dependent and gradient information often
% misleads algorithms.
%
% * It is unimodal function
% * Minima : [0, 0, ..., 0]
% * Maxima : 2508237869
% * Maximum Dimensionality : 30
% 
% Function definition
%
% $$f(<x_i>) = \sum_{i=1}^{n-1} 100(x_{i+1}-x_i^2)^2+(x_i-1)^2$$
%
% 3D Plot
    clc; clear
    x = -10:10; y = -10:10;
    xy=zeros(length(x)*length(y),2);
    cntpts=0;
    for ii=1:length(x)
        for jj=1:length(y)
            cntpts=cntpts+1;
            xy(cntpts,1:2)=[x(ii),y(jj)];
        end
    end
    funval = Rosenbrock([xy]);
    funval = reshape(funval, length(y),length(x));
    surfc(x, y, funval)
%%
% *Other Useful Functions*
% 
% <DeJong>  <Rosenbrock> <Ackley> <Alpine> <Rastrigin>  <Griewank> <Schaffer>
%